export const calculateVariationPrice = (variations, processPrice) => {
    const price = {
        regularPrice: null,
        sellPrice: null,
    };

    let regularPrice = [];
    let salePrice = [];
    for (let i of variations) {
        i.regular_price && regularPrice.push(i.regular_price);
        i.sale_price && salePrice.push(i.sale_price);
    }

    const regMin = regularPrice.length ? Math.min(...regularPrice) : null;
    const regMax = regularPrice.length ? Math.max(...regularPrice) : null;
    const saleMin = salePrice.length ? Math.min(...salePrice) : null;
    const saleMax = salePrice.length ? Math.max(...salePrice) : null;

    price.regularPrice = regularPrice.length
        ? `${processPrice(regMin)} - ${processPrice(regMax)}`
        : null;
    price.sellPrice = salePrice.length
        ? `${processPrice(saleMin)} - ${processPrice(saleMax)}`
        : null;

    return price;
};
